﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace UHFDemo
{
    public partial class RdWrDialog : Form
    {
        [DllImport("UhfDll.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern bool AS3992_CallWriteTag(byte mem_type, byte addr, byte[] password, byte[] data, byte datalen, ref byte retstatus);
        [DllImport("UhfDll.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern bool AS3992_CallReadFromTag(byte mem_type, byte addr, byte datalen, ref byte retstatus, byte[] retdata, ref byte retdatalen);

        public RdWrDialog()
        {
            InitializeComponent();

            this.comboBox_rdBank.Items.Add("Reserved");
            this.comboBox_rdBank.Items.Add("EPC");
            this.comboBox_rdBank.Items.Add("TID");
            this.comboBox_rdBank.Items.Add("USER");
            this.comboBox_rdBank.SelectedIndex = 3;
            this.textBox_rdAddr.Text = "0";
            this.textBox_rdLen.Text = "4";

            this.comboBox_wtBank.Items.Add("Reserved");
            this.comboBox_wtBank.Items.Add("EPC");
            this.comboBox_wtBank.Items.Add("TID");
            this.comboBox_wtBank.Items.Add("USER");
            this.comboBox_wtBank.SelectedIndex = 3;
            this.textBox_wtAddr.Text = "0";
            this.textBox_wtPWD.MaxLength = 11;
            this.textBox_wtPWD.Text = "00 00 00 00";
        }

        private void button1_Click(object sender, EventArgs e)
        {
            byte addr = Convert.ToByte(this.textBox_rdAddr.Text, 16);
            byte datalen = Convert.ToByte(this.textBox_rdLen.Text, 16);
            byte status = 0;
            byte[] retdata = new byte[256];
            byte retdatalen = 0;
            if (AS3992_CallReadFromTag((byte)this.comboBox_rdBank.SelectedIndex, addr, datalen, ref status, retdata, ref retdatalen))
            {
                string tmp = "";
                for (int i = 0; i < retdatalen * 2; i++)
                {
                    tmp += String.Format("{0:X2}", retdata[i]);
                }
                this.textBox_rdData.Text = tmp;
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            byte addr = Convert.ToByte(this.textBox_wtAddr.Text, 16);
            byte[] password = Form_Main.HexStringtoHex(this.textBox_wtPWD.Text.Replace(" ", ""));
            byte[] data = Form_Main.HexStringtoHex(this.textBox_wtData.Text);
            byte status = 0;
            AS3992_CallWriteTag((byte)this.comboBox_wtBank.SelectedIndex, addr, password, data, (byte)(data.Length / 2), ref status);
        }
    }
}
